<?php $venue_id = tribe_get_venue_id(get_the_ID()) ?>
<div class="col_33">
    <div class="item">
        <a href="<?php the_permalink($venue_id) ?>" class="image">
            <img src="<?php echo wp_get_attachment_image_url(get_field('image', $venue_id), 'full') ?>" alt="">
        </a>
        <div class="content">
            <?php if ($bonus_number = get_field('bonus_number', $venue_id)) : ?>
                <div class="price"><?php echo $bonus_number ?></div>
            <?php endif; ?>
            <a href="<?php the_permalink($venue_id) ?>" class="title">
                <?php if ($bonus_text = get_field('bonus_text', $venue_id)) : ?>
                    <strong><?php echo $bonus_text ?></strong>
                <?php else : ?>
                    <?php the_title() ?>
                <?php endif; ?>
            </a>
            <div class="info_bottom">

                <ul class="list_option">
                    <li>
                        <div class="icon">
                            <?php include locate_template('assets/img/time_icon.svg'); ?>
                        </div>
                        <?php echo tribe_get_start_date(get_the_ID(), false, 'g:i A') ?>
                    </li>
                    <li>
                        <div class="icon">
                            <?php include locate_template('assets/img/location_icon.svg'); ?>
                        </div>
                        <?php echo tribe_get_city($venue_id) ?>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>